/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicalUserInterface;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import products.Item;
import salesApplication.PriceList;

/**
 *
 * @author DWTStudent
 */
public class PriceListTableModel extends AbstractTableModel {
    List<Item> list; //the price list we want to display in our table
    
    //Base the content of this table on a list of items from a price list
    public PriceListTableModel(PriceList priceList){
        this.list=priceList.getList();//set the pricelist to whatever price list the demo list
    }
    
    //Must override this method
    public int getRowCount(){
        return list.size();
    }
    //Must override this method
    public int getColumnCount(){
        return 3;
    };
    
    //Must override this method.
    //It should return an object to be displayed for a given row and column number
    public Object getValueAt(int row, int column){
        switch (column){
            case 0:
                return list.get(row).getName();
            case 1:
                return list.get(row).getDescription();
            case 2:
                return list.get(row).getFormattedPrice();
            default:
                return null;
        }
    }
    
    //If you want headings you can override this method to provide a heading 
    //for a given column number    
    public String getColumnName(int column){
        switch (column){
            case 0:
                return "Name";
            case 1:
                return "Description";
            case 2:
                return "Price";
            default:
                return null;
        }
    }
}
